#include "3DSCLASS.h"
#include "fdebug.h"

int main(int argc, char *argv[])
{
	C3dsFile Data;
	FILE *file;
	CObList *pList;
	DWORD Cpt1;

	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char path[_MAX_PATH];

	if (argc<2)
	{
		FMSG("Not enough args\n");
		return 1;
	}

	_splitpath(argv[1], NULL, NULL, fname, ext);

	Data.LoadFile(argv[1]);
	Data.Process();

	file = fopen("result.txt", "w");
	if (file==NULL)
	{
		FMSG("_fopen_ error\n");
		return 1;
	}
	
	pList = Data.GetList();

	Data.RemoveEmptyObjects();

	for(Cpt1=0;Cpt1<30;Cpt1++)
		fprintf(file, "#");
	fprintf(file, "\n");

	VECTOR Min, Max;
	if (Data.GetMinMax(&Min, &Max)==true)
	{
		fprintf(file, "Min: %f %f %f\n", Min.x, Min.y, Min.z);
		fprintf(file, "Max: %f %f %f\n", Max.x, Max.y, Max.z);
	}

	Data.Center();

	if (Data.GetMinMax(&Min, &Max)==true)
	{
		fprintf(file, "Min: %f %f %f\n", Min.x, Min.y, Min.z);
		fprintf(file, "Max: %f %f %f\n", Max.x, Max.y, Max.z);
	}

	Data.Export(fname);

	while(pList->IsEmpty()==false)
	{
		CObj3d *pObj;

		pObj = (CObj3d*)pList->RemoveHead();
		pObj->fprint(file);
		delete pObj;
	}
	
	fclose(file);

	return 0;
}